//=============================================================================
// Shop Button, for when no one's watching the shop!
// THIS TYPE CREATES CUSTOM WEAPONS MADE BY THE CUSTOM WEAPON PROCESS
//=============================================================================
class CustomWeaponCheckButton extends MSCCraftingDeco;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var int TempInt;
var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

var() MSCCraftingMutator Storage;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
        /*reliable if ( Role < ROLE_Authority )
                ItemPrice, bInModMode;*/
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
 if (EstimatePrice(DeusExPlayer(Frobber)) <= 0)
 {
  Pawn(Frobber).ClientMessage("|p4You have not built your custom weapon yet.");
  return;
 }

 PlaySound(buttonSound1, SLOT_None);
 Pawn(Frobber).ClientMessage("|p3You would buy your custom weapon at the cost of "$EstimatePrice( DeusExPlayer(Frobber) )$" Dollars!");
}

//===========================================================================================================
//God Damn, longest mother-fucking function variable list in UScript History, Parabolic Trace Ain't got game.
//In related news, it doesnt fit either! So it's now 2 functions...
//===========================================================================================================
//function SortInfo(String IPToUse, out int WNum, out int MNum, out class<Ammo> A, out sound s1, out sound s2, out sound s3, out sound s4, out int bSpecAcc, out int bSpecPen, out int bSpecDam, out int bSpecScope, out int bSpecSilencer, out int bSpecKnockback, out int bSpecClipSize, out int bSpecRecoil, out int bSpecRange)

function SortSpecs(String BaseSpecs,  out int bSpecAcc, out int bSpecPen, out int bSpecDam, out int bSpecScope, out int bSpecSilencer, out int bSpecKnockback, out int bSpecClipSize, out int bSpecRecoil, out int bSpecRange)
{
 local string S;
 
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 BaseSpecs = Right(BaseSpecs, Len(BaseSpecs) - inStr(BaseSpecs, ",") - 1);
 
 S = BaseSpecs;
 
 bSpecAcc = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecPen = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecDam = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecScope = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecSilencer = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecKnockback = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecClipSize = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecRecoil = Int(Bool( Left(S, inStr(S, ",")) ));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecRange = Int(Bool( Left(S, inStr(S, ",")) ));
 
 //BroadcastMessage(bSpecAcc@bSpecPen@bSpecDam@bSpecScope@bSpecSilencer@bSpecKnockback@bSpecClipSize@bSpecRecoil@bSpecRange);
 
 return;
}

function SortInfo(string BaseInfo, out int WNum, out int MNum, out class<Ammo> A, out sound s1, out sound s2, out sound s3, out sound s4, out String Specs)
{
 local string S, CurS;
 
 S = BaseInfo;
 
 //Weapon Type
 //---------------
 WNum = Int( Left(S, inStr(S, ",")) ); 
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //Weapon Mesh
 //---------------
 MNum = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //Ammo Type
 //---------------
 A = class<Ammo>( DynamicLoadObject( Left(S, inStr(S, ",")), class'Class') );
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //Fire Sound
 //---------------
 S1 = Sound( DynamicLoadObject( Left(S, inStr(S, ",")), class'Sound') );
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //Reload Sound
 //---------------
 S2 = Sound( DynamicLoadObject( Left(S, inStr(S, ",")), class'Sound') );
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //FinishReload Sound
 //---------------
 S3 = Sound( DynamicLoadObject( Left(S, inStr(S, ",")), class'Sound') );
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //Select Sound
 //---------------
 S4 = Sound( DynamicLoadObject( Left(S, inStr(S, ",")), class'Sound') );
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 //A, P, D, SC, SL, KB, CS, RC, RA - the 9 specs (now fits on one line!)
 //---------------
 
 Specs = S;

 /*bSpecAcc = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecPen = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecDam = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecScope = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecSilencer = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecKnockback = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecClipSize = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecRecoil = Int(Left(S, inStr(S, ",")));
 S = Right(S, Len(S) - inStr(S, ",") - 1);
 
 bSpecRange = Int(Left(S, inStr(S, ",")));*/

 return;
}

function int EstimatePrice(DeusExPlayer P)
{
	 local string FrobbersIP;
	 local string S;
	 local int WNum, MNum, bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockback, bSpecClipSize, bSpecRecoil, bSpecRange;
	 local class<Ammo> A;
	 local sound s1, s2, s3, s4;
	 
	 local int TotalCost;
	 
	 FrobbersIP = P.GetPlayerNetworkAddress();
	 FrobbersIP = Left(FrobbersIP, InStr(FrobbersIP, ":"));
	 	 
	 //SortInfo(Storage.GetWeaponInfo(FrobbersIP), WNum, MNum, A, s1, s2, s3, s4, bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockback, bSpecClipSize, bSpecRecoil, bSpecRange);
	 
	 SortInfo(Storage.GetWeaponInfo(FrobbersIP), WNum, MNum, A, s1, s2, s3, s4, S);
	 	 
	 SortSpecs(Storage.GetWeaponInfo(FrobbersIP), bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockback, bSpecClipSize, bSpecRecoil, bSpecRange);
	 
	 if (WNum == 1) TotalCost += 450;
	 if (WNum == 2) TotalCost += 625;
	 if (WNum == 3) TotalCost += 400;
	 if (WNum == 4) TotalCost += 275;
	 if (WNum == 5) TotalCost += 700;
	 if (WNum == 6) TotalCost += 650;
	 
	 if (bSpecAcc > 0) TotalCost += 150;
	 if (bSpecPen > 0) TotalCost += 100;
	 if (bSpecDam > 0) TotalCost += 225;
	 if (bSpecScope > 0) TotalCost += 175;
	 if (bSpecSilencer > 0) TotalCost += 200;
	 if (bSpecKnockBack > 0) TotalCost += 225;
	 if (bSpecClipSize > 0) TotalCost += 300;
	 if (bSpecRecoil > 0) TotalCost += 250;
	 if (bSpecRange > 0) TotalCost += 125;
	 	 
	 return TotalCost;
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     bCollideActors=True
     bBlockActors=True
     bProjTarget=True
     ItemName="|p3Check Custom Weapon Price"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
     Skin=Texture'PriceCheckButton'
}
